<?php

/**
 * @author Tom Needham <tom@owncloud.com>
 *
 * @copyright Copyright (c) 2017, ownCloud GmbH
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

namespace OCA\ConfigReport;

use OCP\IURLGenerator;
use OCP\Settings\ISettings;
use OCP\Template;

class AdminPanel implements ISettings {
	/** @var IURLGenerator  */
	protected $urlGenerator;

	public function __construct(IURLGenerator $urlGenerator) {
		$this->urlGenerator = $urlGenerator;
	}

	public function getPanel() {
		$tmpl = new Template('configreport', 'settings/admin');
		$tmpl->assign('urlGenerator', $this->urlGenerator);
		return $tmpl;
	}

	public function getPriority() {
		return 10;
	}

	public function getSectionID() {
		return 'general';
	}
}
